import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class ProfileService {
  constructor(private prisma: PrismaService) {}

  // প্রোফাইল পান
  async getProfile(userId: string) {
    const user = await this.prisma.user.findUnique({
      where: { id: userId },
      include: {
        addresses: true,
        paymentMethods: true,
        orders: { take: 10, orderBy: { createdAt: 'desc' } }
      }
    });

    return { user };
  }

  // শিপিং অ্যাড্রেস যোগ করুন
  async addShippingAddress(userId: string, address: any) {
    const shippingAddress = await this.prisma.shippingAddress.create({
      data: { userId, ...address }
    });

    return { success: true, data: shippingAddress };
  }

  // ডিফল্ট অ্যাড্রেস সেট করুন
  async setDefaultAddress(userId: string, addressId: string) {
    // পুরানো ডিফল্ট আনসেট করুন
    await this.prisma.shippingAddress.updateMany({
      where: { userId, isDefault: true },
      data: { isDefault: false }
    });

    // নতুন ডিফল্ট সেট করুন
    const address = await this.prisma.shippingAddress.update({
      where: { id: addressId },
      data: { isDefault: true }
    });

    return { success: true, data: address };
  }

  // পেমেন্ট মেথড যোগ করুন
  async addPaymentMethod(userId: string, method: any) {
    const paymentMethod = await this.prisma.paymentMethod.create({
      data: { userId, ...method }
    });

    return { success: true, data: paymentMethod };
  }
}