import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class WholesalerAffiliateService {
  constructor(private prisma: PrismaService) {}

  // অ্যাফিলিয়েট লিঙ্ক তৈরি করুন
  async generateAffiliateLink(
    wholesalerId: string,
    productId: string,
    affiliateId: string
  ): Promise<string> {
    const link = `${process.env.APP_URL}/aff/${wholesalerId}/${productId}?ref=${affiliateId}`;
    return link;
  }

  // অ্যাফিলিয়েট কমিশন ট্র্যাক করুন
  async trackAffiliateClick(wholesalerId: string, affiliateId: string, productId: string) {
    // ক্লিক লগ করুন
    // TODO: Create AffiliateClick model
  }

  // অ্যাফিলিয়েট কমিশন ক্যালকুলেট করুন
  async calculateCommission(
    wholesalerId: string,
    affiliateId: string,
    saleAmount: number,
    commissionPercent: number = 10
  ): Promise<number> {
    return (saleAmount * commissionPercent) / 100;
  }
}