import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class WholesalerAnalyticsService {
  constructor(private prisma: PrismaService) {}

  // হোলসেলার ড্যাশবোর্ড ডেটা পান
  async getDashboardMetrics(wholesalerId: string) {
    const analytics = await this.prisma.wholesaleAnalytics.findFirst({
      where: { wholesalerId }
    });

    // রিয়েল-টাইম ডেটা আপডেট করুন
    const orders = await this.prisma.wholesaleOrder.findMany({
      where: { wholesalerId }
    });

    const totalRevenue = orders.reduce((sum, o) => sum + Number(o.totalAmount), 0);
    const avgOrderValue = orders.length > 0 ? totalRevenue / orders.length : 0;

    // টপ পণ্য পান
    const topProducts = await this.getTopProducts(wholesalerId);

    // টপ বায়ার পান
    const topBuyers = await this.getTopBuyers(wholesalerId);

    return {
      success: true,
      data: {
        totalOrders: orders.length,
        totalRevenue,
        avgOrderValue,
        onTimeDelivery: analytics?.onTimeDelivery || 100,
        returnRate: analytics?.returnRate || 0,
        topProducts,
        topBuyers
      }
    };
  }

  private async getTopProducts(wholesalerId: string) {
    // টপ বিক্রিত পণ্য পান
    const orders = await this.prisma.wholesaleOrder.findMany({
      where: { wholesalerId }
    });

    const products: any = {};

    for (const order of orders) {
      const items = order.items as any[];
      for (const item of items) {
        if (!products[item.productId]) {
          products[item.productId] = { qty: 0, revenue: 0 };
        }
        products[item.productId].qty += item.qty;
        products[item.productId].revenue += item.price * item.qty;
      }
    }

    return Object.entries(products)
      .sort((a: any, b: any) => b[1].revenue - a[1].revenue)
      .slice(0, 10);
  }

  private async getTopBuyers(wholesalerId: string) {
    // টপ ক্রেতা পান
    const orders = await this.prisma.wholesaleOrder.findMany({
      where: { wholesalerId }
    });

    const buyers: any = {};

    for (const order of orders) {
      // TODO: Get buyer info from order
      // buyer count & revenue calculation
    }

    return [];
  }
}