import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class WholesalerDashboardService {
  constructor(private prisma: PrismaService) {}

  // হোলসেলার ড্যাশবোর্ড ডেটা পান
  async getDashboardMetrics(wholesalerTenantId: string) {
    // সংযুক্ত স্টোর পান
    const connectedStores = await this.prisma.adminWholesalerConnection.count({
      where: { wholesalerTenantId, status: 'active' }
    });

    // মাসিক আর্নিং পান
    const thisMonth = new Date();
    thisMonth.setDate(1);

    const settlement = await this.prisma.paymentSettlement.findFirst({
      where: {
        wholesalerTenantId,
        period: `${thisMonth.getFullYear()}-${String(thisMonth.getMonth() + 1).padStart(2, '0')}`
      }
    });

    // সম্প্রতি অর্ডার পান
    const recentOrders = await this.prisma.order.findMany({
      where: {
        items: {
          some: {
            wholesalerId: wholesalerTenantId
          }
        }
      },
      take: 5,
      orderBy: { createdAt: 'desc' }
    });

    return {
      success: true,
      data: {
        connectedStores,
        monthlyEarnings: settlement?.payableAmount || 0,
        totalEarnings: settlement?.totalEarnings || 0,
        recentOrders
      }
    };
  }
}