import {
  Controller,
  Post,
  Get,
  Body,
  UseGuards,
  Req,
  Query
} from '@nestjs/common';
import { ApiTags, ApiBearerAuth } from '@nestjs/swagger';
import { WholesalerService } from './wholesaler.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@ApiTags('Wholesaler')
@Controller('wholesaler')
@UseGuards(JwtAuthGuard)
export class WholesalerController {
  constructor(private wholesalerService: WholesalerService) {}

  @Post('register')
  @ApiBearerAuth()
  async register(@Req() req: any, @Body() dto: any) {
    return await this.wholesalerService.registerWholesaler(
      req.user.tenantId,
      req.user.sub,
      dto
    );
  }

  @Post('products/sync')
  @ApiBearerAuth()
  async syncProducts(@Req() req: any, @Body() body: { products: any[] }) {
    return await this.wholesalerService.uploadWholesalerProducts(
      req.user.sub,
      req.user.tenantId,
      body.products
    );
  }

  @Get('orders')
  @ApiBearerAuth()
  async getOrders(@Req() req: any, @Query('skip') skip = 0, @Query('take') take = 20) {
    return await this.wholesalerService.getWholesaleOrders(req.user.sub, skip, take);
  }

  @Post('pricing-tiers')
  @ApiBearerAuth()
  async updatePricingTiers(
    @Req() req: any,
    @Body() body: { productId: string; tiers: any[] }
  ) {
    return await this.wholesalerService.updateTieredPricing(
      req.user.sub,
      body.productId,
      body.tiers
    );
  }

  @Get('dashboard')
  @ApiBearerAuth()
  async getDashboard(@Req() req: any) {
    return await this.wholesalerService.getWholesalerDashboard(req.user.sub);
  }
}