import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class WishlistService {
  constructor(private prisma: PrismaService) {}

  // উইশলিস্টে যোগ করুন
  async addToWishlist(userId: string, productId: string) {
    const item = await this.prisma.wishlistItem.create({
      data: { userId, productId }
    });

    return { success: true, data: item };
  }

  // উইশলিস্ট পান
  async getWishlist(userId: string) {
    const items = await this.prisma.wishlistItem.findMany({
      where: { userId },
      include: { product: true }
    });

    return { items };
  }

  // উইশলিস্ট শেয়ার করুন
  async shareWishlist(userId: string, recipientEmails: string[]) {
    const wishlist = await this.getWishlist(userId);

    // প্রতিটি প্রাপকের কাছে ইমেইল পাঠান
    recipientEmails.forEach((email) => {
      // ইমেইল লজিক
      console.log(`Wishlist shared with ${email}`);
    });

    return { success: true };
  }

  // মূল্য পরিবর্তনের নোটিফিকেশন
  async notifyPriceDrops(userId: string) {
    const items = await this.prisma.wishlistItem.findMany({
      where: { userId },
      include: { product: true }
    });

    // মূল্য ড্রপের জন্য চেক করুন
    items.forEach((item) => {
      if (item.product.price < item.product.previousPrice) {
        // ইউজারকে নোটিফাই করুন
        console.log(`Price drop for ${item.product.title}`);
      }
    });

    return { success: true };
  }
}