import React from 'react';

interface OptimizedImageProps {
  src: string;
  alt: string;
  width?: number;
  height?: number;
}

export default function OptimizedImage({
  src,
  alt,
  width,
  height
}: OptimizedImageProps) {
  return (
    <picture>
      {/* AVIF (সবচেয়ে ভালো কম্প্রেশন) */}
      <source
        srcSet={src.replace(/\.[^.]+$/, '.avif')}
        type="image/avif"
      />

      {/* WebP (ভালো কম্প্রেশন) */}
      <source
        srcSet={src.replace(/\.[^.]+$/, '.webp')}
        type="image/webp"
      />

      {/* Fallback */}
      <img
        src={src}
        alt={alt}
        width={width}
        height={height}
        loading="lazy"
        style={{ maxWidth: '100%', height: 'auto' }}
      />
    </picture>
  );
}