import React, { useState } from 'react';
import axios from 'axios';
import QRCode from 'qrcode.react';

export default function QRCodeGenerator({ affiliateLink }: { affiliateLink: string }) {
  const [qrCodeUrl, setQrCodeUrl] = useState<string>('');

  const generateQRCode = async () => {
    const token = localStorage.getItem('accessToken');
    const res = await axios.post(
      `${process.env.NEXT_PUBLIC_API_URL}/affiliate/generate-qr`,
      { link: affiliateLink },
      { headers: { Authorization: `Bearer ${token}` } }
    );

    setQrCodeUrl(res.data.qrCodeUrl);
  };

  return (
    <div style={{ textAlign: 'center' }}>
      <button onClick={generateQRCode}>Generate QR Code</button>

      {qrCodeUrl && (
        <>
          <img src={qrCodeUrl} alt="QR Code" style={{ maxWidth: '300px' }} />
          <a href={qrCodeUrl} download>
            Download QR Code
          </a>
        </>
      )}
    </div>
  );
}