import React, { useState } from 'react';
import axios from 'axios';

export default function VoiceAssistant() {
  const [isListening, setIsListening] = useState(false);
  const [transcript, setTranscript] = useState('');

  const startListening = async () => {
    const recognition = new (window.webkitSpeechRecognition || window.SpeechRecognition)();
    recognition.continuous = false;
    recognition.interimResults = true;

    recognition.onstart = () => {
      setIsListening(true);
    };

    recognition.onresult = async (event) => {
      let interimTranscript = '';

      for (let i = event.resultIndex; i < event.results.length; i++) {
        const transcript = event.results[i][0].transcript;

        if (event.results[i].isFinal) {
          setTranscript(transcript);

          // কমান্ড এক্সিকিউট করুন
          await executeVoiceCommand(transcript);
        } else {
          interimTranscript += transcript;
        }
      }
    };

    recognition.onend = () => {
      setIsListening(false);
    };

    recognition.start();
  };

  const executeVoiceCommand = async (command: string) => {
    const token = localStorage.getItem('accessToken');

    try {
      const response = await axios.post(
        `${process.env.NEXT_PUBLIC_API_URL}/ai/voice-command`,
        { command },
        { headers: { Authorization: `Bearer ${token}` } }
      );

      // কমান্ড এক্সিকিউট করুন
      if (response.data.action === 'navigate') {
        window.location.href = response.data.url;
      } else if (response.data.action === 'search') {
        // সার্চ ইউআই আপডেট করুন
        console.log('Search for:', response.data.query);
      }
    } catch (err) {
      console.error('Voice command failed:', err);
    }
  };

  return (
    <div className="voice-assistant">
      <button
        onClick={startListening}
        className={`mic-button ${isListening ? 'listening' : ''}`}
      >
        🎙️ {isListening ? 'Listening...' : 'Click to speak'}
      </button>
      {transcript && <p>You said: {transcript}</p>}
    </div>
  );
}