import React, { useEffect, useState } from 'react';
import axios from 'axios';
import {
  BarChart,
  Bar,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  Legend,
  ResponsiveContainer
} from 'recharts';

export default function AffiliatePerformance() {
  const [affiliateData, setAffiliateData] = useState<any[]>([]);

  useEffect(() => {
    const fetchData = async () => {
      const token = localStorage.getItem('accessToken');
      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/analytics/affiliates`,
        { headers: { Authorization: `Bearer ${token}` } }
      );

      setAffiliateData(res.data.data);
    };

    fetchData();
  }, []);

  return (
    <div>
      <h2>Affiliate Performance</h2>

      <ResponsiveContainer width="100%" height={400}>
        <BarChart data={affiliateData}>
          <CartesianGrid strokeDasharray="3 3" />
          <XAxis dataKey="name" />
          <YAxis yAxisId="left" />
          <YAxis yAxisId="right" orientation="right" />
          <Tooltip />
          <Legend />
          <Bar yAxisId="left" dataKey="clicks" fill="#8884d8" name="Clicks" />
          <Bar
            yAxisId="left"
            dataKey="conversions"
            fill="#82ca9d"
            name="Conversions"
          />
          <Bar
            yAxisId="right"
            dataKey="commission"
            fill="#ffc658"
            name="Commission ($)"
          />
        </BarChart>
      </ResponsiveContainer>
    </div>
  );
}