import React, { useEffect, useState } from 'react';
import axios from 'axios';
import Heatmap from 'heatmap.js';
import styles from '../../styles/ClickHeatmap.module.css';

export default function ClickHeatmap({ pageUrl }: { pageUrl: string }) {
  const heatmapRef = React.useRef<any>(null);
  const [heatmapInstance, setHeatmapInstance] = useState<any>(null);

  useEffect(() => {
    // Heatmap.js ইনিশিয়ালাইজ করুন
    const instance = h337.create({
      container: heatmapRef.current,
      radius: 40,
      maxOpacity: 0.9,
      minOpacity: 0.1,
      blur: 85,
      gradient: {
        '.0': '#0000FF',
        '.25': '#00FF00',
        '.50': '#FFFF00',
        '.75': '#FF7F00',
        '1.0': '#FF0000'
      }
    });

    setHeatmapInstance(instance);

    // হিটম্যাপ ডেটা ফেচ করুন
    const fetchHeatmapData = async () => {
      const token = localStorage.getItem('accessToken');
      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/analytics/heatmap`,
        {
          params: { pageUrl },
          headers: { Authorization: `Bearer ${token}` }
        }
      );

      // ডেটা ফরম্যাট করুন
      const data = res.data.clicks.map((click: any) => ({
        x: click.clickX,
        y: click.clickY,
        value: click.clickCount
      }));

      instance.setData({
        max: 100,
        min: 0,
        data: data
      });
    };

    fetchHeatmapData();
  }, [pageUrl]);

  return (
    <div className={styles.container}>
      <h2>Click Heatmap - {pageUrl}</h2>
      <div ref={heatmapRef} className={styles.heatmap} />
      <p className={styles.info}>
        🔥 Red = Most clicks | 🟢 Green = Medium | 🔵 Blue = Least clicks
      </p>
    </div>
  );
}