import React, { useEffect, useState } from 'react';
import axios from 'axios';
import styles from '../../styles/ConversionFunnel.module.css';

export default function ConversionFunnel() {
  const [funnel, setFunnel] = useState<any[]>([]);

  useEffect(() => {
    const fetchFunnel = async () => {
      const token = localStorage.getItem('accessToken');
      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/analytics/funnel`,
        { headers: { Authorization: `Bearer ${token}` } }
      );

      setFunnel(res.data.funnel);
    };

    fetchFunnel();
  }, []);

  return (
    <div className={styles.container}>
      <h2>Conversion Funnel</h2>

      <div className={styles.funnel}>
        {funnel.map((step, index) => {
          const width = (step.completedUsers / (funnel[0]?.uniqueUsers || 1)) * 100;
          const dropOff =
            index > 0
              ? ((funnel[index - 1].completedUsers - step.completedUsers) /
                  funnel[index - 1].completedUsers) *
                100
              : 0;

          return (
            <div key={step.step} className={styles.step}>
              <div
                className={styles.funnel_bar}
                style={{
                  width: `${Math.max(width, 20)}%`
                }}
              >
                <span className={styles.label}>{step.stepName}</span>
              </div>

              <div className={styles.stats}>
                <p>{step.uniqueUsers.toLocaleString()} users</p>
                <p className={styles.conversion}>
                  {step.conversionRate.toFixed(2)}%
                </p>
                {index > 0 && (
                  <p className={styles.dropoff}>
                    ↓ {dropOff.toFixed(2)}% drop-off
                  </p>
                )}
              </div>
            </div>
          );
        })}
      </div>

      {/* সুপারিশ */}
      <div className={styles.recommendations}>
        <h3>Optimization Tips</h3>
        {funnel
          .filter((step) => step.dropOffRate > 30)
          .map((step) => (
            <div key={step.step} className={styles.warning}>
              <p>
                <strong>{step.stepName}</strong> has {step.dropOffRate.toFixed(2)}%
                drop-off. Consider optimizing this step.
              </p>
            </div>
          ))}
      </div>
    </div>
  );
}