import React, { useEffect, useState } from 'react';
import axios from 'axios';
import styles from '../../styles/GeoMap.module.css';

export default function GeoMap() {
  const [geoData, setGeoData] = useState<any[]>([]);
  const [mapKey, setMapKey] = useState(0);

  useEffect(() => {
    const fetchGeoData = async () => {
      const token = localStorage.getItem('accessToken');
      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/analytics/geo`,
        { headers: { Authorization: `Bearer ${token}` } }
      );

      setGeoData(res.data.data);
    };

    fetchGeoData();
  }, []);

  // Google Maps API ব্যবহার করে মানচিত্র প্রদর্শন
  useEffect(() => {
    if (!window.google || geoData.length === 0) return;

    const map = new window.google.maps.Map(
      document.getElementById('geoMap'),
      {
        zoom: 2,
        center: { lat: 20, lng: 0 }
      }
    );

    // মার্কার যোগ করুন
    geoData.forEach((location) => {
      new window.google.maps.Marker({
        position: { lat: location.latitude, lng: location.longitude },
        map: map,
        title: `${location.city}, ${location.country} - ${location.visitors} visitors`
      });
    });
  }, [geoData]);

  return (
    <div className={styles.container}>
      <h2>Visitor Locations</h2>

      <div id="geoMap" className={styles.map} />

      {/* টেবিল ভিউ */}
      <table className={styles.table}>
        <thead>
          <tr>
            <th>Country</th>
            <th>City</th>
            <th>Visitors</th>
            <th>Conversions</th>
            <th>Revenue</th>
          </tr>
        </thead>
        <tbody>
          {geoData.map((location) => (
            <tr key={`${location.country}-${location.city}`}>
              <td>{location.country}</td>
              <td>{location.city || '-'}</td>
              <td>{location.visitors.toLocaleString()}</td>
              <td>{location.conversions}</td>
              <td>${location.revenue.toFixed(2)}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}