import React, { useEffect, useState } from 'react';
import axios from 'axios';
import {
  LineChart,
  Line,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  Legend,
  ResponsiveContainer
} from 'recharts';
import styles from '../../styles/RealTimeTraffic.module.css';

export default function RealTimeTraffic() {
  const [trafficData, setTrafficData] = useState<any[]>([]);

  useEffect(() => {
    // রিয়েল-টাইম ট্রাফিক ডেটা ফেচ করুন
    const fetchRealTimeData = async () => {
      const token = localStorage.getItem('accessToken');
      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/analytics/realtime`,
        { headers: { Authorization: `Bearer ${token}` } }
      );

      setTrafficData(res.data.data);
    };

    // প্রতি ১০ সেকেন্ডে আপডেট করুন
    const interval = setInterval(fetchRealTimeData, 10000);

    fetchRealTimeData();

    return () => clearInterval(interval);
  }, []);

  return (
    <div className={styles.container}>
      <h2>Real-Time Traffic</h2>

      <ResponsiveContainer width="100%" height={400}>
        <LineChart data={trafficData}>
          <CartesianGrid strokeDasharray="3 3" />
          <XAxis dataKey="time" />
          <YAxis />
          <Tooltip />
          <Legend />
          <Line
            type="monotone"
            dataKey="visitors"
            stroke="#0088FE"
            name="Visitors"
          />
          <Line
            type="monotone"
            dataKey="pageViews"
            stroke="#00C49F"
            name="Page Views"
          />
        </LineChart>
      </ResponsiveContainer>

      {/* লাইভ সংখ্যা */}
      <div className={styles.liveStats}>
        <div className={styles.stat}>
          <h3>Current Visitors</h3>
          <p className={styles.number}>
            {trafficData[trafficData.length - 1]?.visitors || 0}
          </p>
        </div>
        <div className={styles.stat}>
          <h3>Page Views/min</h3>
          <p className={styles.number}>
            {trafficData[trafficData.length - 1]?.pageViews || 0}
          </p>
        </div>
      </div>
    </div>
  );
}