import React, { useEffect, useState } from 'react';
import axios from 'axios';
import {
  LineChart,
  Line,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  Legend,
  ResponsiveContainer
} from 'recharts';

export default function RetentionCurve() {
  const [cohortData, setCohortData] = useState<any[]>([]);

  useEffect(() => {
    const fetchData = async () => {
      const token = localStorage.getItem('accessToken');
      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/analytics/retention`,
        { headers: { Authorization: `Bearer ${token}` } }
      );

      setCohortData(res.data.data);
    };

    fetchData();
  }, []);

  return (
    <div>
      <h2>Retention Curve (Cohort Analysis)</h2>

      <ResponsiveContainer width="100%" height={400}>
        <LineChart data={cohortData}>
          <CartesianGrid strokeDasharray="3 3" />
          <XAxis dataKey="day" />
          <YAxis />
          <Tooltip />
          <Legend />
          <Line
            type="monotone"
            dataKey="day0"
            stroke="#8884d8"
            name="Day 0 (100%)"
          />
          <Line
            type="monotone"
            dataKey="day7"
            stroke="#82ca9d"
            name="Day 7"
          />
          <Line
            type="monotone"
            dataKey="day30"
            stroke="#ffc658"
            name="Day 30"
          />
          <Line
            type="monotone"
            dataKey="day90"
            stroke="#ff7c7c"
            name="Day 90"
          />
        </LineChart>
      </ResponsiveContainer>

      <div style={{ marginTop: '20px' }}>
        <h3>Insights</h3>
        <ul>
          <li>Identify churn patterns</li>
          <li>Understand user lifecycle</li>
          <li>Plan retention strategies</li>
        </ul>
      </div>
    </div>
  );
}