import React, { useState, useEffect } from 'react';
import axios from 'axios';

export default function LivePreview({ pageId }: { pageId: string }) {
  const [preview, setPreview] = useState('');
  const [autoRefresh, setAutoRefresh] = useState(true);

  useEffect(() => {
    if (autoRefresh) {
      const interval = setInterval(async () => {
        const token = localStorage.getItem('accessToken');
        const res = await axios.get(
          `${process.env.NEXT_PUBLIC_API_URL}/builder/preview/${pageId}`,
          { headers: { Authorization: `Bearer ${token}` } }
        );
        setPreview(res.data.html);
      }, 1000);

      return () => clearInterval(interval);
    }
  }, [pageId, autoRefresh]);

  return (
    <div style={{ display: 'grid', gridTemplateColumns: '1fr 1fr', gap: '1rem' }}>
      <div style={{ border: '1px solid #ddd' }}>
        <p>Editor (আপনার পরিবর্তন)</p>
      </div>
      <div
        style={{
          border: '1px solid #ddd',
          background: '#fff',
          overflow: 'auto',
          height: '600px'
        }}
        dangerouslySetInnerHTML={{ __html: preview }}
      />
      <button onClick={() => setAutoRefresh(!autoRefresh)}>
        Auto Refresh: {autoRefresh ? 'ON' : 'OFF'}
      </button>
    </div>
  );
}