import React, { useEffect, useState } from 'react';
import axios from 'axios';
import styles from '../../styles/ShoppingCart.module.css';

export default function ShoppingCart() {
  const [cart, setCart] = useState<any>(null);

  useEffect(() => {
    const fetchCart = async () => {
      const sessionId = localStorage.getItem('sessionId');
      const token = localStorage.getItem('accessToken');

      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/cart`,
        {
          params: { sessionId },
          headers: token ? { Authorization: `Bearer ${token}` } : {}
        }
      );

      setCart(res.data.cart);
    };

    fetchCart();
  }, []);

  const removeFromCart = async (productId: string) => {
    const token = localStorage.getItem('accessToken');
    const sessionId = localStorage.getItem('sessionId');

    await axios.delete(
      `${process.env.NEXT_PUBLIC_API_URL}/cart/${productId}`,
      {
        params: { sessionId },
        headers: token ? { Authorization: `Bearer ${token}` } : {}
      }
    );

    // কার্ট আপডেট করুন
  };

  if (!cart) return <div>Loading...</div>;

  return (
    <div className={styles.container}>
      <h1>Shopping Cart</h1>

      {cart.items.length === 0 ? (
        <p>Your cart is empty</p>
      ) : (
        <>
          <div className={styles.items}>
            {cart.items.map((item: any) => (
              <div key={item.productId} className={styles.cartItem}>
                <div className={styles.info}>
                  <h4>{item.productName}</h4>
                  <p>Price: ${item.price}</p>
                  <p>Quantity: {item.quantity}</p>
                </div>
                <p className={styles.subtotal}>
                  Subtotal: ${(item.price * item.quantity).toFixed(2)}
                </p>
                <button onClick={() => removeFromCart(item.productId)}>Remove</button>
              </div>
            ))}
          </div>

          <div className={styles.summary}>
            <h3>Cart Summary</h3>
            <p>Total: ${cart.totalAmount.toFixed(2)}</p>
            <button className={styles.checkoutBtn}>Proceed to Checkout</button>
          </div>
        </>
      )}
    </div>
  );
}