import React, { useState, useEffect } from 'react';
import styles from '../../styles/Chat.module.css';

export default function WholesalerChat({ wholesalerId }: { wholesalerId: string }) {
  const [messages, setMessages] = useState<any[]>([]);
  const [newMessage, setNewMessage] = useState('');
  const [isConnected, setIsConnected] = useState(false);

  useEffect(() => {
    const ws = new WebSocket(
      `${process.env.NEXT_PUBLIC_WS_URL}/chat/${wholesalerId}`
    );

    ws.onopen = () => setIsConnected(true);
    ws.onmessage = (event) => {
      const msg = JSON.parse(event.data);
      setMessages([...messages, msg]);
    };
    ws.onclose = () => setIsConnected(false);

    return () => ws.close();
  }, [wholesalerId]);

  const sendMessage = async () => {
    if (!newMessage.trim()) return;

    const ws = new WebSocket(
      `${process.env.NEXT_PUBLIC_WS_URL}/chat/${wholesalerId}`
    );
    ws.send(JSON.stringify({ text: newMessage }));

    setNewMessage('');
  };

  return (
    <div className={styles.chatContainer}>
      <div className={styles.messages}>
        {messages.map((msg, i) => (
          <div key={i} className={msg.sender === 'me' ? styles.sent : styles.received}>
            {msg.text}
          </div>
        ))}
      </div>

      <div className={styles.inputArea}>
        <input
          type="text"
          value={newMessage}
          onChange={(e) => setNewMessage(e.target.value)}
          onKeyPress={(e) => e.key === 'Enter' && sendMessage()}
          placeholder="Type message..."
          disabled={!isConnected}
        />
        <button onClick={sendMessage} disabled={!isConnected}>
          Send
        </button>
      </div>
    </div>
  );
}