import React, { useEffect, useState } from 'react';

interface StockCounterProps {
  stock: number;
  lowThreshold?: number;
}

export default function StockCounter({ stock, lowThreshold = 10 }: StockCounterProps) {
  const isLow = stock <= lowThreshold;

  return (
    <div style={{ padding: '1rem', border: '1px solid #ddd' }}>
      {stock > 0 ? (
        <>
          <p style={{ color: isLow ? '#dc3545' : '#28a745' }}>
            {stock} in stock
          </p>
          {isLow && <p style={{ color: '#ff6b6b', fontWeight: 'bold' }}>⚠️ Only {stock} left!</p>}
        </>
      ) : (
        <p style={{ color: '#999' }}>Out of stock</p>
      )}
    </div>
  );
}

// Countdown Timer
export function UrgencyTimer({ endsAt }: { endsAt: Date }) {
  const [timeLeft, setTimeLeft] = useState('');

  useEffect(() => {
    const interval = setInterval(() => {
      const now = new Date();
      const diff = new Date(endsAt).getTime() - now.getTime();

      if (diff <= 0) {
        setTimeLeft('Offer ended');
        clearInterval(interval);
      } else {
        const hours = Math.floor(diff / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        setTimeLeft(`${hours}h ${minutes}m left`);
      }
    }, 1000);

    return () => clearInterval(interval);
  }, [endsAt]);

  return (
    <div style={{ background: '#fff3cd', padding: '0.5rem 1rem', textAlign: 'center' }}>
      <strong>⏱️ {timeLeft}</strong>
    </div>
  );
}