import React, { useState } from 'react';
import { useTranslation } from 'next-i18next';

export default function LanguageSwitcher() {
  const { i18n } = useTranslation();

  return (
    <select
      value={i18n.language}
      onChange={(e) => i18n.changeLanguage(e.target.value)}
    >
      <option value="en">English</option>
      <option value="bn">বাংলা</option>
      <option value="hi">हिंदी</option>
      <option value="ar">العربية</option>
    </select>
  );
}