import React, { useState, useEffect } from 'react';
import axios from 'axios';

export default function CurrencyDisplay({ basePrice }: { basePrice: number }) {
  const [currency, setCurrency] = useState('USD');
  const [displayPrice, setDisplayPrice] = useState(basePrice);

  useEffect(() => {
    // ইউজারের দেশ থেকে কারেন্সি ডিটেক্ট করুন
    const detectCurrency = async () => {
      try {
        const res = await axios.get('https://ipapi.co/json/');
        const country = res.data.country_code;

        const currencyMap: any = {
          BD: 'BDT',
          IN: 'INR',
          US: 'USD',
          GB: 'GBP',
          DE: 'EUR'
        };

        const detectedCurrency = currencyMap[country] || 'USD';
        setCurrency(detectedCurrency);

        // এক্সচেঞ্জ রেট পান এবং প্রাইস কনভার্ট করুন
        const rateRes = await axios.get(
          `https://api.exchangerate-api.com/v4/latest/USD`
        );
        const rate = rateRes.data.rates[detectedCurrency];
        setDisplayPrice(basePrice * rate);
      } catch (err) {
        console.error('Currency detection failed');
      }
    };

    detectCurrency();
  }, [basePrice]);

  const currencySymbols: any = {
    USD: '$',
    BDT: '৳',
    INR: '₹',
    GBP: '£',
    EUR: '€'
  };

  return (
    <p className="price">
      {currencySymbols[currency]}
      {displayPrice.toFixed(2)} {currency}
    </p>
  );
}