import React, { useState, useEffect } from 'react';
import styles from '../../styles/PWAPrompt.module.css';

export default function PWAInstallPrompt() {
  const [deferredPrompt, setDeferredPrompt] = useState<any>(null);
  const [showPrompt, setShowPrompt] = useState(false);

  useEffect(() => {
    window.addEventListener('beforeinstallprompt', (e) => {
      e.preventDefault();
      setDeferredPrompt(e);
      setShowPrompt(true);
    });

    window.addEventListener('appinstalled', () => {
      console.log('PWA installed');
    });
  }, []);

  const handleInstall = async () => {
    if (deferredPrompt) {
      deferredPrompt.prompt();
      const { outcome } = await deferredPrompt.userChoice;
      console.log(`User response: ${outcome}`);
      setDeferredPrompt(null);
      setShowPrompt(false);
    }
  };

  if (!showPrompt) return null;

  return (
    <div className={styles.prompt}>
      <h3>Install App</h3>
      <p>Get the best experience with our app installed on your device</p>
      <div className={styles.actions}>
        <button onClick={handleInstall}>Install</button>
        <button onClick={() => setShowPrompt(false)}>Maybe Later</button>
      </div>
    </div>
  );
}