import React, { useState } from 'react';
import axios from 'axios';
import styles from '../../styles/VoiceSearch.module.css';

export default function VoiceSearch() {
  const [isListening, setIsListening] = useState(false);
  const [searchResults, setSearchResults] = useState<any[]>([]);
  const [recognition, setRecognition] = useState<any>(null);

  React.useEffect(() => {
    // Web Speech API সেটআপ করুন
    const SpeechRecognition = (window as any).SpeechRecognition || (window as any).webkitSpeechRecognition;

    if (SpeechRecognition) {
      const newRecognition = new SpeechRecognition();
      newRecognition.continuous = false;
      newRecognition.interimResults = false;
      newRecognition.lang = 'en-US';

      newRecognition.onstart = () => setIsListening(true);
      newRecognition.onend = () => setIsListening(false);

      newRecognition.onresult = async (event: any) => {
        const voiceInput = event.results[0][0].transcript;

        // ভয়েস ইনপুট দিয়ে সার্চ করুন
        const res = await axios.get(
          `${process.env.NEXT_PUBLIC_API_URL}/search?q=${voiceInput}`
        );

        setSearchResults(res.data.products);
      };

      setRecognition(newRecognition);
    }
  }, []);

  const startListening = () => {
    if (recognition) {
      recognition.start();
    }
  };

  const stopListening = () => {
    if (recognition) {
      recognition.abort();
    }
  };

  return (
    <div className={styles.container}>
      <button
        className={`${styles.voiceButton} ${isListening ? styles.listening : ''}`}
        onClick={isListening ? stopListening : startListening}
        title="Voice Search"
      >
        🎤 {isListening ? 'Listening...' : 'Search by Voice'}
      </button>

      {/* রেজাল্ট */}
      {searchResults.length > 0 && (
        <div className={styles.results}>
          {searchResults.map((product) => (
            <div key={product.id} className={styles.resultItem}>
              <img src={Array.isArray(product.images) ? product.images[0] : ''} alt={product.title} />
              <div>
                <h4>{product.title}</h4>
                <p>${product.price}</p>
              </div>
            </div>
          ))}
        </div>
      )}
    </div>
  );
}