// Next.js middleware
import { NextResponse } from 'next/server';
import type { NextRequest } from 'next/server';

export async function middleware(request: NextRequest) {
  // Check maintenance status
  const tenantHost = request.headers.get('host');
  
  try {
    const res = await fetch(
      `${process.env.NEXT_PUBLIC_API_URL}/settings/maintenance`,
      { headers: { 'X-Tenant-Host': tenantHost } }
    );

    const { maintenanceMode, maintenanceText } = await res.json();

    if (maintenanceMode) {
      return new NextResponse(
        `<html><body><h1>Maintenance Mode</h1><p>${maintenanceText}</p></body></html>`,
        { status: 503, headers: { 'Content-Type': 'text/html' } }
      );
    }
  } catch (err) {
    // Continue if check fails
  }

  return NextResponse.next();
}

export const config = {
  matcher: ['/:path*']
};