import React, { useEffect, useState } from 'react';
import axios from 'axios';
import styles from '../../styles/LoyaltyPoints.module.css';

export default function LoyaltyPointsPage() {
  const [points, setPoints] = useState<any>(null);
  const [history, setHistory] = useState<any[]>([]);
  const [redeemAmount, setRedeemAmount] = useState(100);

  useEffect(() => {
    const fetchPoints = async () => {
      const token = localStorage.getItem('accessToken');

      const [pointsRes, historyRes] = await Promise.all([
        axios.get(`${process.env.NEXT_PUBLIC_API_URL}/loyalty/balance`, {
          headers: { Authorization: `Bearer ${token}` }
        }),
        axios.get(`${process.env.NEXT_PUBLIC_API_URL}/loyalty/history`, {
          headers: { Authorization: `Bearer ${token}` }
        })
      ]);

      setPoints(pointsRes.data);
      setHistory(historyRes.data.transactions);
    };

    fetchPoints();
  }, []);

  const redeemPoints = async () => {
    const token = localStorage.getItem('accessToken');

    await axios.post(
      `${process.env.NEXT_PUBLIC_API_URL}/loyalty/redeem`,
      { points: redeemAmount },
      { headers: { Authorization: `Bearer ${token}` } }
    );

    alert(`${redeemAmount} points redeemed!`);
  };

  if (!points) return <div>Loading...</div>;

  return (
    <div className={styles.container}>
      <h1>My Loyalty Points</h1>

      {/* পয়েন্ট সামারি */}
      <div className={styles.summary}>
        <div className={styles.card}>
          <h3>Total Points</h3>
          <p className={styles.value}>{points.totalPoints}</p>
        </div>

        <div className={styles.card}>
          <h3>Used Points</h3>
          <p className={styles.value}>{points.usedPoints}</p>
        </div>

        <div className={styles.card}>
          <h3>Available Points</h3>
          <p className={styles.value}>{points.availablePoints}</p>
        </div>

        <div className={styles.card}>
          <h3>Estimated Reward</h3>
          <p className={styles.value}>${(points.availablePoints / 100).toFixed(2)}</p>
        </div>
      </div>

      {/* রিডিম */}
      <div className={styles.redeem}>
        <h3>Redeem Points</h3>
        <input
          type="number"
          value={redeemAmount}
          onChange={(e) => setRedeemAmount(parseInt(e.target.value))}
          min="100"
          step="10"
        />
        <button onClick={redeemPoints}>
          Redeem ${(redeemAmount / 100).toFixed(2)} Discount
        </button>
      </div>

      {/* হিস্ট্রি */}
      <div className={styles.history}>
        <h3>Points History</h3>
        <table>
          <thead>
            <tr>
              <th>Description</th>
              <th>Points</th>
              <th>Date</th>
            </tr>
          </thead>
          <tbody>
            {history.map((tx) => (
              <tr key={tx.id}>
                <td>{tx.description}</td>
                <td className={tx.type === 'earned' ? styles.earned : styles.redeemed}>
                  {tx.points > 0 ? '+' : ''}{tx.points}
                </td>
                <td>{new Date(tx.createdAt).toLocaleDateString()}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}