import React, { useState } from 'react';
import axios from 'axios';
import styles from '../../styles/ThemeSelector.module.css';

export default function ThemesPage() {
  const [themes, setThemes] = useState<any[]>([]);
  const [selectedTheme, setSelectedTheme] = useState('');

  React.useEffect(() => {
    const fetchThemes = async () => {
      const res = await axios.get(
        `${process.env.NEXT_PUBLIC_API_URL}/themes/premium`
      );
      setThemes(res.data.themes);
    };
    fetchThemes();
  }, []);

  const applyTheme = async (themeId: string) => {
    const token = localStorage.getItem('accessToken');

    await axios.post(
      `${process.env.NEXT_PUBLIC_API_URL}/themes/apply`,
      { themeId },
      { headers: { Authorization: `Bearer ${token}` } }
    );

    setSelectedTheme(themeId);
    alert('Theme applied successfully!');
  };

  return (
    <div className={styles.container}>
      <h1>Choose Your Store Theme</h1>

      <div className={styles.themeGrid}>
        {themes.map((theme) => (
          <div
            key={theme.id}
            className={`${styles.themeCard} ${selectedTheme === theme.id ? styles.selected : ''}`}
            onClick={() => applyTheme(theme.id)}
          >
            {/* থিম প্রিভিউ */}
            <div
              className={styles.preview}
              style={{
                background: `linear-gradient(135deg, ${theme.colors?.primary || '#000'} 0%, ${theme.colors?.accent || '#fff'} 100%)`
              }}
            />

            <h3>{theme.name}</h3>
            <p>{theme.description}</p>

            <button>
              {selectedTheme === theme.id ? '✓ Applied' : 'Apply Theme'}
            </button>
          </div>
        ))}
      </div>
    </div>
  );
}