import React, { useState } from 'react';
import axios from 'axios';
import styles from '../../styles/AffiliateRegister.module.css';

export default function AffiliateRegistrationPage() {
  const [formData, setFormData] = useState({
    commissionRate: 10,
    paymentMethod: 'bkash',
    paymentAccount: ''
  });
  const [isSubmitting, setIsSubmitting] = useState(false);

  const handleRegister = async () => {
    setIsSubmitting(true);

    const token = localStorage.getItem('accessToken');

    try {
      const res = await axios.post(
        `${process.env.NEXT_PUBLIC_API_URL}/affiliate/register`,
        formData,
        { headers: { Authorization: `Bearer ${token}` } }
      );

      alert('Registration successful! Start earning now!');
      window.location.href = `/affiliate/dashboard/${res.data.affiliateId}`;
    } catch (err) {
      alert('Registration failed');
    } finally {
      setIsSubmitting(false);
    }
  };

  return (
    <div className={styles.container}>
      <h1>Join Our Affiliate Program</h1>
      <p>Start earning commission on every sale!</p>

      <div className={styles.form}>
        <label>
          Commission Rate (%):
          <input
            type="number"
            value={formData.commissionRate}
            onChange={(e) => setFormData({ ...formData, commissionRate: parseFloat(e.target.value) })}
            min="1"
            max="50"
          />
        </label>

        <label>
          Payment Method:
          <select
            value={formData.paymentMethod}
            onChange={(e) => setFormData({ ...formData, paymentMethod: e.target.value })}
          >
            <option value="bkash">bKash</option>
            <option value="nagad">Nagad</option>
            <option value="paypal">PayPal</option>
            <option value="bank_transfer">Bank Transfer</option>
          </select>
        </label>

        <label>
          Account Number / Email:
          <input
            type="text"
            value={formData.paymentAccount}
            onChange={(e) => setFormData({ ...formData, paymentAccount: e.target.value })}
            placeholder="Your payment account"
          />
        </label>

        <button onClick={handleRegister} disabled={isSubmitting}>
          {isSubmitting ? 'Registering...' : 'Join Affiliate Program'}
        </button>
      </div>

      <div className={styles.benefits}>
        <h3>Benefits:</h3>
        <ul>
          <li>💰 Earn commission on every sale</li>
          <li>📊 Real-time tracking & analytics</li>
          <li>🎁 Bonuses for top performers</li>
          <li>🚀 Marketing tools & resources</li>
        </ul>
      </div>
    </div>
  );
}