import React, { useEffect, useState } from 'react';
import axios from 'axios';
import styles from '../../styles/CustomerDashboard.module.css';

export default function CustomerDashboard() {
  const [customer, setCustomer] = useState<any>(null);
  const [orders, setOrders] = useState<any[]>([]);
  const [wishlist, setWishlist] = useState<any[]>([]);
  const [activeTab, setActiveTab] = useState('orders');

  useEffect(() => {
    const fetchData = async () => {
      const token = localStorage.getItem('accessToken');

      const [customerRes, ordersRes, wishlistRes] = await Promise.all([
        axios.get(`${process.env.NEXT_PUBLIC_API_URL}/customer/profile`, {
          headers: { Authorization: `Bearer ${token}` }
        }),
        axios.get(`${process.env.NEXT_PUBLIC_API_URL}/customer/orders`, {
          headers: { Authorization: `Bearer ${token}` }
        }),
        axios.get(`${process.env.NEXT_PUBLIC_API_URL}/customer/wishlist`, {
          headers: { Authorization: `Bearer ${token}` }
        })
      ]);

      setCustomer(customerRes.data);
      setOrders(ordersRes.data);
      setWishlist(wishlistRes.data);
    };

    fetchData();
  }, []);

  return (
    <div className={styles.dashboard}>
      <h1>My Dashboard</h1>

      {/* ট্যাব */}
      <div className={styles.tabs}>
        <button
          className={activeTab === 'orders' ? styles.active : ''}
          onClick={() => setActiveTab('orders')}
        >
          My Orders
        </button>
        <button
          className={activeTab === 'wishlist' ? styles.active : ''}
          onClick={() => setActiveTab('wishlist')}
        >
          Wishlist
        </button>
        <button
          className={activeTab === 'profile' ? styles.active : ''}
          onClick={() => setActiveTab('profile')}
        >
          Profile
        </button>
        <button
          className={activeTab === 'refunds' ? styles.active : ''}
          onClick={() => setActiveTab('refunds')}
        >
          Refunds
        </button>
      </div>

      {/* অর্ডার */}
      {activeTab === 'orders' && (
        <div className={styles.content}>
          <h2>My Orders</h2>
          {orders.map((order) => (
            <div key={order.id} className={styles.orderCard}>
              <h4>Order #{order.orderNumber}</h4>
              <p>Status: {order.status}</p>
              <p>Total: ${order.total}</p>
              <p>Date: {new Date(order.createdAt).toLocaleDateString()}</p>
            </div>
          ))}
        </div>
      )}

      {/* উইশলিস্ট */}
      {activeTab === 'wishlist' && (
        <div className={styles.content}>
          <h2>My Wishlist</h2>
          <div className={styles.grid}>
            {wishlist.map((item) => (
              <div key={item.id} className={styles.wishlistItem}>
                <img src={Array.isArray(item.product.images) ? item.product.images[0] : ''} alt={item.product.title} />
                <h4>{item.product.title}</h4>
                <p>${item.product.price}</p>
              </div>
            ))}
          </div>
        </div>
      )}

      {/* প্রোফাইল */}
      {activeTab === 'profile' && (
        <div className={styles.content}>
          <h2>My Profile</h2>
          <p>Name: {customer?.name}</p>
          <p>Email: {customer?.email}</p>
          <p>Phone: {customer?.phone}</p>
        </div>
      )}
    </div>
  );
}