import React, { useState } from 'react';
import axios from 'axios';
import styles from '../../styles/Campaigns.module.css';

export default function CampaignsPage() {
  const [campaigns, setCampaigns] = useState<any[]>([]);
  const [showBuilder, setShowBuilder] = useState(false);
  const [newCampaign, setNewCampaign] = useState({
    name: '',
    subject: '',
    htmlContent: '',
    segmentType: 'all'
  });

  const createCampaign = async () => {
    const token = localStorage.getItem('accessToken');
    const res = await axios.post(
      `${process.env.NEXT_PUBLIC_API_URL}/campaigns`,
      newCampaign,
      { headers: { Authorization: `Bearer ${token}` } }
    );

    setCampaigns([...campaigns, res.data.data]);
    setShowBuilder(false);
    setNewCampaign({ name: '', subject: '', htmlContent: '', segmentType: 'all' });
  };

  return (
    <div className={styles.container}>
      <h1>Email Campaigns</h1>

      {!showBuilder ? (
        <div>
          <button onClick={() => setShowBuilder(true)}>+ New Campaign</button>

          <div className={styles.campaignsGrid}>
            {campaigns.map((campaign) => (
              <div key={campaign.id} className={styles.campaignCard}>
                <h3>{campaign.name}</h3>
                <p>Subject: {campaign.subject}</p>
                <p>Recipients: {campaign.recipientCount}</p>
                <p>Status: <span className={styles[campaign.status]}>{campaign.status}</span></p>
                {campaign.sentAt && (
                  <p>Open Rate: {campaign.openRate}% | Click Rate: {campaign.clickRate}%</p>
                )}
              </div>
            ))}
          </div>
        </div>
      ) : (
        <div className={styles.builder}>
          <h2>Create New Campaign</h2>

          <input
            type="text"
            placeholder="Campaign Name"
            value={newCampaign.name}
            onChange={(e) => setNewCampaign({ ...newCampaign, name: e.target.value })}
          />

          <input
            type="text"
            placeholder="Email Subject"
            value={newCampaign.subject}
            onChange={(e) => setNewCampaign({ ...newCampaign, subject: e.target.value })}
          />

          <select
            value={newCampaign.segmentType}
            onChange={(e) => setNewCampaign({ ...newCampaign, segmentType: e.target.value })}
          >
            <option value="all">All Subscribers</option>
            <option value="purchased">Customers (Purchased)</option>
            <option value="inactive">Inactive Customers</option>
            <option value="custom">Custom Segment</option>
          </select>

          <textarea
            placeholder="Email Content (HTML)"
            value={newCampaign.htmlContent}
            onChange={(e) => setNewCampaign({ ...newCampaign, htmlContent: e.target.value })}
            style={{ minHeight: '300px' }}
          />

          <div className={styles.actions}>
            <button onClick={createCampaign}>Create Draft</button>
            <button onClick={() => setShowBuilder(false)}>Cancel</button>
          </div>
        </div>
      )}
    </div>
  );
}