import React, { useState } from 'react';
import axios from 'axios';
import styles from '../../styles/BulkEditor.module.css';

export default function BulkEditorPage() {
  const [selectedProducts, setSelectedProducts] = useState<string[]>([]);
  const [action, setAction] = useState('price');
  const [changes, setChanges] = useState<any>({});

  const performBulkEdit = async () => {
    const token = localStorage.getItem('accessToken');

    try {
      await axios.post(
        `${process.env.NEXT_PUBLIC_API_URL}/products/bulk-edit`,
        {
          productIds: selectedProducts,
          editType: action,
          changes
        },
        { headers: { Authorization: `Bearer ${token}` } }
      );

      alert(`Successfully updated ${selectedProducts.length} products!`);
      setSelectedProducts([]);
      setChanges({});
    } catch (err) {
      alert('Bulk edit failed');
    }
  };

  return (
    <div className={styles.container}>
      <h1>Bulk Editor</h1>

      <div className={styles.editor}>
        <div className={styles.section}>
          <h3>Select Products</h3>
          <p>{selectedProducts.length} products selected</p>
          {/* Product selection UI */}
        </div>

        <div className={styles.section}>
          <h3>Action</h3>
          <select value={action} onChange={(e) => setAction(e.target.value)}>
            <option value="price">Update Price</option>
            <option value="stock">Update Stock</option>
            <option value="category">Change Category</option>
            <option value="tag">Add Tags</option>
          </select>
        </div>

        {action === 'price' && (
          <div className={styles.section}>
            <h3>Price Changes</h3>
            <select
              value={changes.type || 'fixed'}
              onChange={(e) => setChanges({ ...changes, type: e.target.value })}
            >
              <option value="fixed">Set Fixed Price</option>
              <option value="percentage">Adjust by Percentage</option>
            </select>
            <input
              type="number"
              placeholder={changes.type === 'percentage' ? 'Percentage (+/-10)' : 'Price'}
              value={changes.value || ''}
              onChange={(e) => setChanges({ ...changes, value: parseFloat(e.target.value) })}
            />
          </div>
        )}

        {action === 'stock' && (
          <div className={styles.section}>
            <h3>Stock Changes</h3>
            <select
              value={changes.type || 'set'}
              onChange={(e) => setChanges({ ...changes, type: e.target.value })}
            >
              <option value="set">Set Stock to</option>
              <option value="add">Add to Stock</option>
            </select>
            <input
              type="number"
              placeholder="Quantity"
              value={changes.value || ''}
              onChange={(e) => setChanges({ ...changes, value: parseInt(e.target.value) })}
            />
          </div>
        )}

        <button className={styles.submitBtn} onClick={performBulkEdit}>
          Apply Changes
        </button>
      </div>
    </div>
  );
}