import React, { useState } from 'react';
import axios from 'axios';
import styles from '../../styles/SetupWizard.module.css';

export default function SetupWizard() {
  const [step, setStep] = useState(0);
  const [formData, setFormData] = useState({
    businessName: '',
    businessEmail: '',
    businessPhone: '',
    businessType: 'b2c'
  });

  const nextStep = async () => {
    const token = localStorage.getItem('accessToken');

    // বর্তমান ধাপ সংরক্ষণ করুন
    await axios.post(
      `${process.env.NEXT_PUBLIC_API_URL}/setup/step${step + 1}`,
      formData,
      { headers: { Authorization: `Bearer ${token}` } }
    );

    setStep(step + 1);
  };

  return (
    <div className={styles.wizard}>
      <div className={styles.progress}>
        <div className={styles.bar} style={{ width: `${(step / 4) * 100}%` }} />
      </div>

      {step === 0 && (
        <div className={styles.step}>
          <h1>Welcome to Your Store! 🎉</h1>
          <p>Let's set up your online store in a few simple steps.</p>
          <button onClick={nextStep}>Let's Get Started</button>
        </div>
      )}

      {step === 1 && (
        <div className={styles.step}>
          <h2>Business Information</h2>
          <input
            type="text"
            placeholder="Business Name"
            value={formData.businessName}
            onChange={(e) => setFormData({ ...formData, businessName: e.target.value })}
          />
          <input
            type="email"
            placeholder="Business Email"
            value={formData.businessEmail}
            onChange={(e) => setFormData({ ...formData, businessEmail: e.target.value })}
          />
          <input
            type="tel"
            placeholder="Business Phone"
            value={formData.businessPhone}
            onChange={(e) => setFormData({ ...formData, businessPhone: e.target.value })}
          />
          <select
            value={formData.businessType}
            onChange={(e) => setFormData({ ...formData, businessType: e.target.value })}
          >
            <option value="b2c">B2C (Sell to customers)</option>
            <option value="b2b">B2B (Sell to businesses)</option>
            <option value="both">Both B2C & B2B</option>
          </select>
          <button onClick={nextStep}>Next</button>
        </div>
      )}

      {step === 2 && (
        <div className={styles.step}>
          <h2>Add Your First Products</h2>
          <p>You can add more products later. Let's start with a few!</p>
          <button onClick={nextStep}>+ Add Product</button>
          <button onClick={nextStep} style={{ background: '#28a745' }}>Continue</button>
        </div>
      )}

      {step === 3 && (
        <div className={styles.step}>
          <h2>Payment Gateway Setup</h2>
          <p>Choose how you want to accept payments</p>
          <button>bKash / Nagad (Bangladesh)</button>
          <button>Stripe / PayPal (International)</button>
          <button onClick={nextStep} style={{ background: '#28a745' }}>Continue</button>
        </div>
      )}

      {step === 4 && (
        <div className={styles.step}>
          <h2>Shipping Setup</h2>
          <p>Select your preferred shipping partners</p>
          <label>
            <input type="checkbox" defaultChecked /> Pathao Courier
          </label>
          <label>
            <input type="checkbox" defaultChecked /> Aramex
          </label>
          <label>
            <input type="checkbox" /> DHL
          </label>
          <button onClick={nextStep} style={{ background: '#28a745' }}>Complete Setup</button>
        </div>
      )}

      {step === 5 && (
        <div className={styles.step}>
          <h1>Your Store is Ready! 🎊</h1>
          <p>Start selling now and reach thousands of customers!</p>
          <button onClick={() => window.location.href = '/dashboard'}>
            Go to Dashboard
          </button>
        </div>
      )}
    </div>
  );
}