# 🌐 AWS Production Deployment

## Prerequisites
- AWS Account ✅
- AWS CLI configured ✅
- kubectl installed ✅
- eksctl installed (for EKS) ✅

## Step 1: Create VPC & Security Groups

aws ec2 create-vpc \
  --cidr-block 10.0.0.0/16 \
  --tag-specifications 'ResourceType=vpc,Tags=[{Key=Name,Value=saas-vpc}]'

# Output: VpcId: vpc-xxxxx

# Create subnets
aws ec2 create-subnet \
  --vpc-id vpc-xxxxx \
  --cidr-block 10.0.1.0/24 \
  --availability-zone us-east-1a

aws ec2 create-subnet \
  --vpc-id vpc-xxxxx \
  --cidr-block 10.0.2.0/24 \
  --availability-zone us-east-1b

# Create Security Group
aws ec2 create-security-group \
  --group-name saas-sg \
  --description "SaaS Security Group" \
  --vpc-id vpc-xxxxx

# Allow inbound traffic
aws ec2 authorize-security-group-ingress \
  --group-id sg-xxxxx \
  --protocol tcp \
  --port 443 \
  --cidr 0.0.0.0/0

aws ec2 authorize-security-group-ingress \
  --group-id sg-xxxxx \
  --protocol tcp \
  --port 80 \
  --cidr 0.0.0.0/0

aws ec2 authorize-security-group-ingress \
  --group-id sg-xxxxx \
  --protocol tcp \
  --port 5432 \
  --cidr 10.0.0.0/16