# 🏢 Multi-Tenant Architecture

## কী?
একটাই সফটওয়্যারের ইনস্টলেশন দিয়ে একাধিক ক্লায়েন্ট (tenant) চালানো যায়।

## বিশেষত্ব
- প্রতিটি ক্লায়েন্টের ডেটা আলাদা ডাটাবেস বা আলাদা স্কিমাতে থাকে
- সম্পূর্ণ ডেটা আইসোলেশন
- স্বাধীন কনফিগারেশন প্রতিটি টেন্যান্টের

## ফায়দা
✅ ডেটা নিরাপত্তা বজায় থাকে
✅ আপডেট/মেইনটেন্যান্স সহজ
✅ কস্ট এফিশিয়েন্ট (শেয়ারড রিসোর্স)
✅ স্কেলেবল - হাজারো টেন্যান্ট হ্যান্ডেল করতে পারে

## টেকনিক্যাল ইমপ্লিমেন্টেশন
- Prisma Multi-Tenant Pattern
- Shared Database + Tenant ID কলাম
- Alternative: Tenant-Per-Database (এন্টারপ্রাইজের জন্য)
- Connection Pooling (PgBouncer)

## কোড এক্সাম্পল
```typescript
// প্রতিটি API request-এ tenant isolation
@UseGuards(JwtAuthGuard)
async getProducts(@Req() req: any) {
  return this.productService.findByTenant(req.user.tenantId);
}

// Prisma query - automatic tenant filtering
await prisma.product.findMany({
  where: { tenantId: req.user.tenantId }
});