import { PrismaClient } from "@prisma/client";

declare global {
  // allow global prisma to prevent multiple instances in development
  // eslint-disable-next-line no-var
  var prisma: PrismaClient | undefined;
}

export const prisma =
  global.prisma ??
  new PrismaClient({
    log: process.env.NODE_ENV === "development" ? ["query", "info", "warn", "error"] : ["error"]
  });

if (process.env.NODE_ENV === "development") {
  global.prisma = prisma;
}