import { EventEmitter } from 'events';

export class PluginSDK extends EventEmitter {
  private apiClient: any;
  private config: any;

  constructor(apiKey: string, apiUrl: string = 'https://api.platform.com') {
    super();
    this.apiClient = new APIClient(apiKey, apiUrl);
  }

  // API Access
  async getProducts(tenantId: string) {
    return this.apiClient.get(`/tenants/${tenantId}/products`);
  }

  async createOrder(tenantId: string, orderData: any) {
    return this.apiClient.post(`/tenants/${tenantId}/orders`, orderData);
  }

  async getCustomers(tenantId: string) {
    return this.apiClient.get(`/tenants/${tenantId}/customers`);
  }

  // Events
  onOrderCreated(callback: (order: any) => void) {
    this.on('order.created', callback);
  }

  onProductUpdated(callback: (product: any) => void) {
    this.on('product.updated', callback);
  }

  // Configuration
  setConfig(config: any) {
    this.config = config;
  }

  getConfig() {
    return this.config;
  }

  // Storage
  async saveData(key: string, value: any) {
    return this.apiClient.post('/plugin/storage', { key, value });
  }

  async getData(key: string) {
    return this.apiClient.get(`/plugin/storage/${key}`);
  }

  // UI Components
  registerMenuItem(label: string, path: string) {
    return this.apiClient.post('/plugin/menu', { label, path });
  }

  registerDashboardWidget(name: string, component: any) {
    return this.apiClient.post('/plugin/widgets', { name, component });
  }
}

// প্লাগইন ব্যবহারের উদাহরণ
export class MyPlugin {
  private sdk: PluginSDK;

  constructor(sdk: PluginSDK) {
    this.sdk = sdk;
    this.initialize();
  }

  private initialize() {
    // Order ইভেন্ট শুনুন
    this.sdk.onOrderCreated(async (order) => {
      console.log('New order:', order);
      
      // কাস্টম লজিক
      const customer = await this.sdk.getCustomers(order.tenantId);
      // অর্ডার প্রসেস করুন
    });

    // মেনু আইটেম যোগ করুন
    this.sdk.registerMenuItem('My Plugin', '/my-plugin');

    // ড্যাশবোর্ড উইজেট যোগ করুন
    this.sdk.registerDashboardWidget('Sales Analytics', SalesWidget);
  }
}