// Shared TypeScript types used across all apps

export type TenantStatus = 'PROVISIONING' | 'ACTIVE' | 'SUSPENDED' | 'DELETED';
export type PlanType = 'FREE' | 'STARTER' | 'PROFESSIONAL' | 'ENTERPRISE';
export type UserRole = 'SUPER_ADMIN' | 'ADMIN' | 'MANAGER' | 'STAFF' | 'CUSTOMER' | 'WHOLESALER' | 'AFFILIATE';
export type OrderStatus = 'PENDING' | 'CONFIRMED' | 'PROCESSING' | 'SHIPPED' | 'DELIVERED' | 'CANCELLED' | 'REFUNDED';
export type SubscriptionStatus = 'ACTIVE' | 'TRIALING' | 'CANCELLED' | 'EXPIRED';

export interface ITenant {
  id: string;
  name: string;
  subdomain: string;
  host: string;
  customDomain?: string;
  plan: PlanType;
  status: TenantStatus;
  country: string;
  currency: string;
  trialEnds?: Date;
  createdAt: Date;
  updatedAt: Date;
}

export interface IUser {
  id: string;
  email: string;
  name: string;
  role: UserRole;
  tenantId?: string;
  emailVerified: boolean;
  twoFactorEnabled: boolean;
  createdAt: Date;
}

export interface IProduct {
  id: string;
  tenantId: string;
  sku: string;
  title: string;
  description?: string;
  price: number;
  stock: number;
  images: string[];
  categoryId?: string;
  status: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface IOrder {
  id: string;
  tenantId: string;
  orderNumber: string;
  userId: string;
  status: OrderStatus;
  total: number;
  items: IOrderItem[];
  createdAt: Date;
}

export interface IOrderItem {
  id: string;
  productId: string;
  quantity: number;
  price: number;
  total: number;
}

export interface ISubscription {
  id: string;
  tenantId: string;
  plan: PlanType;
  status: SubscriptionStatus;
  currentPeriodStart: Date;
  currentPeriodEnd: Date;
}

// API Response Types
export interface ApiResponse<T> {
  success: boolean;
  data?: T;
  error?: string;
  meta?: {
    page?: number;
    limit?: number;
    total?: number;
  };
}

export interface PaginatedResponse<T> {
  items: T[];
  total: number;
  page: number;
  limit: number;
}